------------------------------------------------------------------------------
--CRIANDO O PARAMETRO POR FILIAL
------------------------------------------------------------------------------ 
INSERT INTO GLB_CHAVE 
	(CD_CHAVE
	,DS_CHAVE
	,TP_NIVEL
	,TP_CTRL
	,TP_SISTEMA
	,TP_OCULTO
	,DS_PROCESSO
	,STS_CHAVE
	,QTDE_CHAVES
	,SQL_CHAVE
	,CAMINHO_TELA_CHAVE_ERRO
	,TIPO_SENHA)

SELECT
	'FLAG_HORAS_PRAZO_CANCEL_NFE' AS CD_CHAVE
	,'Prazo em hora para cancelamento de NFE' AS DS_CHAVE
	,1 AS TP_NIVEL
	,0 AS TP_CTRL
	,0 AS TP_SISTEMA
	,0 AS TP_OCULTO
	,'Fiscal' AS DS_PROCESSO
	,0 AS STS_CHAVE
	,NULL AS QTDE_CHAVES
	,'' AS SQL_CHAVE
	,'' AS CAMINHO_TELA_CHAVE_ERRO
	,0 AS TIPO_SENHA
WHERE 
	NOT EXISTS (SELECT 1 FROM GLB_CHAVE WHERE CD_CHAVE = 'FLAG_HORAS_PRAZO_CANCEL_NFE')
 
GO
 
------------------------------------------------------------------------------
--CONFIGURANDO AS FILIAIS COM O PRAZO DE 24 HORAS
------------------------------------------------------------------------------ 
INSERT INTO PRC_FILIAL_CONFIG 
	SELECT 
	CD_EMP
	,CD_FILIAL
	,'FLAG_HORAS_PRAZO_CANCEL_NFE' AS CD_CHAVE
	,24 AS VALOR
	,1 AS CD_USU
	,GETDATE() AS DT_ULT_ALT
	,0 AS GRAVA_MINUSCULO
	FROM  
		PRC_FILIAL
	WHERE 
		NOT EXISTS (SELECT I.CD_EMP 
					FROM PRC_FILIAL_CONFIG I 
					WHERE I.CD_CHAVE = 'FLAG_HORAS_PRAZO_CANCEL_NFE'
						  AND I.CD_FILIAL = PRC_FILIAL.CD_FILIAL)

GO

-------------------------------------------------------------------------------------
--MODIFICANDO O PARAMETRO PARA CANCELAMENTO EM ATE 7 DIAS SE JA ESTIVER CONFIGURADO
-------------------------------------------------------------------------------------
UPDATE T SET 
	VALOR = 168 --7 DIAS
FROM 
	PRC_FILIAL_CONFIG T	
WHERE 	
	CD_CHAVE = 'FLAG_HORAS_PRAZO_CANCEL_NFE'
	AND EXISTS (SELECT C.CD_EMP 
				FROM PRC_FILIAL_CONFIG C 
				WHERE C.CD_CHAVE = 'FLAG_LIBERAR_CANCEL_NFE_MAIS_24_HORAS' 
				  AND C.CD_FILIAL = T.CD_FILIAL 
				  AND C.VALOR = '1')